<?php
	class AlunoController extends AlunoModel {
		private $nome;
		private $email;
		private $dataNasc;
		private $telefone;
		private $endereco;
        private $bi;
		private $genero;
        private $tipoUsuario;

		private $periodo;
		private $curso;

		public function __construct($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $periodo, $curso){
            $this->nome = $nome;
			$this->email = $email;
            $this->dataNasc = $dataNasc;
            $this->telefone = $telefone;
            $this->endereco = $endereco;
            $this->bi = $bi;
            $this->genero = $genero;
            $this->tipoUsuario = $tipoUsuario;
			$this->periodo = $periodo;
            $this->curso = $curso;
		}

		public function deleteUsuario($idUsuario){
			$this->eraseUsuario($idUsuario);
			$this->deleteImg($idUsuario);
		}

		public function deleteImg($idUsuario){
			$img = $this->fotoPerfil($idUsuario);
			$nameImg = "../../images/fotoPerfil/" . $img[0]["imagem"];
			$fileInfo = glob($nameImg);
			$fileExt = explode(".", $fileInfo[0]);
			$fileActualExt = $fileExt[5];
			print_r($nameImg);

        	$file = $nameImg;
			unlink($file);
		}

		public function updateAluno($idAluno){
			//$this->checks();
			
			//$this->deleteImg($idAluno);
			$result = $this->editAluno($idAluno, $this->nome, $this->email, $this->dataNasc, $this->telefone, $this->endereco, $this->bi, $this->genero, $this->tipoUsuario, $this->periodo, $this->curso);

			return $result;
		}

		public function createAluno(){
            //$this->checks();
			$result = $this->insertAluno($this->nome, $this->email, $this->dataNasc, $this->telefone, $this->endereco, $this->bi, $this->genero, $this->tipoUsuario, $this->periodo, $this->curso);
			//$this->insertTurmaAluno($result, $this->periodo, $this->curso);
			//$turmaAluno = $this->verifySetTurma($result);
			return $result;
		}

		public function verifySetTurma($result){
			if($result[0]["idTipoUsuario"] == 2){
				$turma = $this->readTurma();
				for($i = 0; $i < count($turma); $i++){
					$turmaAluno = "";
					if($turma[$i]["capacidade"] != 0){
						$turmaAluno = $this->setTurmaAluno($turma[$i]["idTurma"], $result[0]["idUsuario"]);
						$this->updateTurma($turma[$i]["idTurma"], $turma[$i]["capacidade"]);
						break;
					}
				}
			}
			return $turmaAluno;
		}

		public function updateTurma($idTurma, $capacidade){
			$decremento = $capacidade - 1;
			$result = $this->editTurma($idTurma, $decremento);
			return $result;
		}

		public function setTurmaAluno($idTurma, $idAluno){
			$result = $this->insertTurmaAluno($idTurma, $idAluno);
			return $result;
		}

		public function emptyEntry(){
			if(empty($this->nome)){
				$this->nome = "estudante";
				$result = false;
			} else {
				$this->nome = strtolower(str_replace(" ", "-", $this->nome));
				$result = true;
			}
			return $result;
		}

		public function emptyInput(){
			if(empty($this->nome)){
				$result = false;
			} else {
				$result = true;
			}
			return $result;
		}

		public function checks(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = strtolower(str_replace(" ", "-", $this->nome)) . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/fotoPerfil/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function setPeriodoCurso(int $idUsuario, int $periodo, int $curso){
			$this->idUsuario = $idUsuario;
			$this->periodo = $periodo;
			$this->curso = $curso;
			$result = $this->insertPeriodoCurso($this->$idUsuario, $this->periodo, $this->curso);
			return $result;
		}

	}