<?php
	class DocumentoController extends DocumentoModel {
		private $id;
		private $nomeUsuario;
		private $nome;

		private $ficheiro;
		private $nomeFicheiro;
		private $tipoFicheiro;
		private $nomeTemporarioFicheiro;
		private $erroFicheiro;
		private $tamanhoFicheiro;
		private $extensaoFicheiro;
		private $extensaoActualFicheiro;
		private $permitido;

		private $nomeCompletoDocumento;
		private $destinoFicheiro;

		public function __construct($id, $nomeUsuario, $nome,$ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido){
            $this->id = $id;
			$this->nomeUsuario = $nomeUsuario;
			$this->nome = $nome;

            $this->ficheiro = $ficheiro;
			$this->nomeFicheiro = $nomeFicheiro;
			$this->tipoFicheiro = $tipoFicheiro;
			$this->nomeTemporarioFicheiro = $nomeTemporarioFicheiro;
			$this->erroFicheiro = $erroFicheiro;
			$this->tamanhoFicheiro = $tamanhoFicheiro;
			$this->extensaoFicheiro = $extensaoFicheiro;
			$this->extensaoActualFicheiro = $extensaoActualFicheiro;
			$this->permitido = $permitido;
		}

		public function createDocumento(){
            $this->checks();
			$result = $this->insertDocumento($this->id, $this->nomeUsuario, $this->nome, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoDocumento, $this->destinoFicheiro);
			//$this->insertTurmaAluno($result, $this->periodo, $this->curso);
			//$turmaAluno = $this->verifySetTurma($result);
			return $result;
		}


		public function checks(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoDocumento = strtolower(str_replace(" ", "_", $this->nome)) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../doc/aluno/" . strtolower(str_replace(" ", "_", $this->nomeUsuario)) . "_" .$this->id . "/" . $this->nomeCompletoDocumento;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!: " . $this->extensaoActualFicheiro;
					exit();
				}
			} else {
				$this->nomeCompletoDocumento = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../doc/aluno/" . $this->nomeCompletoDocumento;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

	}