<?php
    class EncarregadoModel extends Database {
        protected function insertEncarregado($nomeCompleto, $nomePai, $nomeMae, $bi, $email, $telefone, $endereco, $nomeUsuario, $senha, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
            $stmt = $this->connect();
            $sql = "INSERT INTO encarregado (nome, nomePai, nomeMae, bi, email, telefone, endereco, nomeUsuario, senha, imagem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

			$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);

            $query->execute(array($nomeCompleto, $nomePai, $nomeMae, $bi, $email, $telefone, $endereco, $nomeUsuario, $hashedSenha, $nomeCompletoImagem));
            move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
			$id = $stmt->lastInsertId();
			return $id;
            //header("location: ../test.php?Cadastro=Sucesso!");
        }

        public function queryEmailUsuario($email){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM encarregado WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryNomeUsuario($nomeUsuario){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM encarregado WHERE nomeUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

        public function listaEncarregado(){
			$data = null;
			$sql = "SELECT * FROM encarregado";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }