<?php
    class EstudanteModel extends Database {
        protected function insertEstudante($idEncarregado, $nomeCompleto, $dataAdmissao, $dataNasc, $genero, $email, $bi, $telefone, $endereco, $idClasse, $idTurno, $nomeUsuario, $senha, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
            $stmt = $this->connect();
			
            $sql = "INSERT INTO estudante (idEncarregado, nome, dataAdmissao, dataNasc, genero, email, bi, telefone, endereco, idClasse, idTurno, nomeUsuario, senha, imagem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

			$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);

            if(!($query->execute(array($idEncarregado, $nomeCompleto, $dataAdmissao, $dataNasc, $genero, $email, $bi, $telefone, $endereco, $idClasse, $idTurno, $nomeUsuario, $hashedSenha, $nomeCompletoImagem)))){
				$query = null;
				header("location: ../test.php?Erro=stmtFalhou!");
				exit();
				$_SESSION['sucesso'] = "nao";
			}
            move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
			$id = $stmt->lastInsertId();
			return $id;
			$_SESSION['sucesso'] = "sim";
            header("location: ../test.php?Cadastro=Sucesso!");
        }

		protected function editEstudante($idEncarregado, $nomeCompleto, $dataAdmissao, $dataNasc, $genero, $email, $bi, $telefone, $endereco, $idClasse, $idTurno, $nomeUsuario, $senha, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
            $stmt = $this->connect();
			
            $sql = "INSERT INTO estudante (idEncarregado, nome, dataAdmissao, dataNasc, genero, email, bi, telefone, endereco, idClasse, idTurno, nomeUsuario, senha, imagem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idEncarregado, $nomeCompleto, $dataAdmissao, $dataNasc, $genero, $email, $bi, $telefone, $endereco, $idClasse, $idTurno, $nomeUsuario, $senha, $nomeCompletoImagem)))){
				$query = null;
				header("location: ../test.php?Erro=stmtFalhou!");
				exit();
				$_SESSION['sucesso'] = "nao";
			}
            move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
			$id = $stmt->lastInsertId();
			return $id;
			$_SESSION['sucesso'] = "sim";
            header("location: ../test.php?Cadastro=Sucesso!");
        }

		public function queryEmailUsuario($email){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM estudante WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryNomeUsuario($nomeUsuario){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM estudante WHERE nomeUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

        public function listaEstudante(){
			$data = null;
			$sql = "SELECT *, e.nome as nomeCompleto FROM estudante e INNER JOIN classe c ON (e.idClasse = c.idClasse) INNER JOIN turnoo t ON (e.idTurno = t.idTurno);";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function dataEstudante($idEstudante){
			$data = null;
			$sql = "SELECT * FROM estudante WHERE idEstudante = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idEstudante]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

        public function queryListaEstudante($idClasse){
			$data = null;
			if($idClasse == 0){
				$sql = "SELECT *, e.nome as nomeCompleto FROM estudante e";
				if($stmt = $this->connect()->query($sql)){
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			} else {
				$sql = "SELECT *, e.nome as nomeCompleto FROM estudante e WHERE idClasse = ?";
				if($stmt = $this->connect()->prepare($sql)){
					$stmt->execute([$idClasse]);
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			}
			return $data;
		}
    }