<?php
    class FacturaModel extends Database {

		protected function insertFactura($idUsuario, $montanteTotal, $descontoTotal, $subTotal, $entregueTotal, $tipoPagamento){
            $stmt = $this->connect();
            $sql = "INSERT INTO factura (idUsuario, montanteTotal, descontoTotal, subTotal, entregueTotal, estado) VALUES (?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idUsuario, $montanteTotal, $descontoTotal, $subTotal, $entregueTotal, $tipoPagamento)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemFactura(){
			$data = null;
			$sql = "SELECT * FROM viewfacturaaluno";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryCursoAluno($idCurso){
			$data = null;
			$sql = "SELECT * FROM curso WHERE idCurso = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idCurso]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryCurso($periodo){
			$data = null;
			$sql = "SELECT * FROM curso WHERE idPeriodo = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$periodo]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function verifyTurmaCurso($curso){
			$data = null;
			$sql = "SELECT * FROM viewcursoturma WHERE capacidade = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$curso]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }