<?php
    class TurmaModel extends Database {

		protected function insertTurma($periodo, $curso, $professor, $nome, $capacidade, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO turma (idPeriodo, idCurso, nome, capacidade, nota) VALUES (?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($periodo, $curso, $nome, $capacidade, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
			
        }

		protected function insertTurmaProf($id, $professor){
			$stmt = $this->connect();
			$sql = "INSERT INTO turmaProf (turma, professor) VALUES (?, ?)";
			$query = $stmt->prepare($sql);
			if(!($query->execute(array($id, $professor)))){
				$query = null;
				exit();
			}
		}

        public function listagemPeriodoCursoTurma(){
			$data = null;
			$sql = "SELECT * FROM viewperiodocursoturma";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemProfessorTurma(){
			$data = null;
			$sql = "SELECT t.*, u.nome AS professor FROM turma t INNER JOIN turmaprof tp ON 
			(t.idTurma = tp.turma) INNER JOIN usuario u ON (tp.professor = u.idUsuario) WHERE idTurma = ?";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryTurma($curso){
			$data = null;
			$sql = "SELECT * FROM turma WHERE idCurso = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$curso]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTurmaDois($idTurma){
			$data = null;
			$sql = "SELECT * FROM viewperiodocursoturma WHERE idTurma = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTurma]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryProfessorTurma($idTurma){
			$data = null;
			$sql = "SELECT * FROM turmaprof WHERE turma = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTurma]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}
    }