<?php

    class SignupController extends SignUpModel{
        private $nome;
        private $nomeUsuario;
        private $telefone;
        private $email;
        private $senha;
        private $reSenha;

        public function __construct($nome, $nomeUsuario, $telefone, $email, $senha, $reSenha){
            $this->nome = $nome;
            $this->nomeUsuario = $nomeUsuario;
            $this->telefone = $telefone;
            $this->email = $email;
            $this->senha = $senha;
            $this->reSenha = $reSenha;
        }

        public function signupUsuario(){
            if($this->emptyInput() == false){
                header("location: ../signin.php?Erro=camposVazios!");
                exit();
            }
            if($this->invalidNomeUsuario() == false){
                header("location: ../signin.php?Erro=NomeUsuarioInvalido!");
                exit();
            }
            if($this->invalidEmail() == false){
                header("location: ../signin.php?Erro=EmailInvalido!");
                exit();
            }
            if($this->senhaMatch() == false){
                header("location: ../signin.php?Erro=SenhasNaoCoinscidem!");
                exit();
            }
            if($this->nomeUsuarioCheck() == false){
                header("location: ../signin.php?Erro=NomeUsuarioEmailExistente!");
                exit();
            }

            $this->insertUsuario($this->nome, $this->nomeUsuario, $this->telefone, $this->email, $this->senha);
        }

        private function emptyInput(){
            if(empty($this->nome) || empty($this->nomeUsuario) || empty($this->telefone) || empty($this->email) || empty($this->senha) || empty($this->reSenha)){
                $result = false;
            } else {
                $result = true;
            }
            return $result;
        }

        private function invalidNomeUsuario(){
            if(!preg_match("/^[a-zA-Z0-9]*$/", $this->nomeUsuario)){
                $result = false;
            } else {
                $result = true;
            }
            return $result;
        }

        private function invalidEmail(){
            if(!filter_var($this->email, FILTER_VALIDATE_EMAIL)){
                $result = false;
            } else {
                $result = true;
            }
            return $result;
        }

        private function senhaMatch(){
            if($this->senha !== $this->reSenha){
                $result = false;
            } else {
                $result = true;
            }
            return $result;
        }

        private function nomeUsuarioCheck(){
            if(!$this->checkUser($this->nomeUsuario, $this->email)){
                $result = false;
            } else {
                $result = true;
            }
            return $result;
        }
    }