<?php
    class UsuarioModel extends Database {

		protected function insertUsuario($nomeCompleto, $dataNasc, $genero, $bi, $email, $telefone, $endereco, $dataAdesao, $idFuncao, $nomeUsuario, $senha, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
            try {
				$stmt = $this->connect();
				$sql = "INSERT INTO usuario (nome, dataNasc, genero, bi, email, telefone, endereco, dataAdesao, idFuncao, nomeUsuario, senha, imagem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				$query = $stmt->prepare($sql);

				$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);

				$query->execute(array($nomeCompleto, $dataNasc, $genero, $bi, $email, $telefone, $endereco, $dataAdesao, $idFuncao, $nomeUsuario, $hashedSenha, $nomeCompletoImagem));
				move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
				$id = $stmt->lastInsertId();
				return $id;
			} catch (\Exception $e) {
				echo "Erro" . $e->getMessage();
				exit();
			}
            header("location: ../test.php?Cadastro=Sucesso!");
        }

        public function queryEmailUsuario($email){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryNomeUsuario($nomeUsuario){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE nomeUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listaUsuario(){
			$data = null;
			$sql = "SELECT * FROM usuario";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }