<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Formulário configuração</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- daterange picker -->
  <link rel="stylesheet" href="../../plugins/daterangepicker/daterangepicker.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="../../plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="../../plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="../../plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="../../plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="../../plugins/bs-stepper/css/bs-stepper.min.css">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="../../plugins/dropzone/min/dropzone.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <form action="../../includes/curso.inc.php" id="formularioCurso" method="post" enctype="multipart/form-data">
               
                    <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                        <div class="card card-default">
                            <div class="card-header">
                            <h3 class="card-title">Formulário de configurações</h3>
                
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                                </button>
                                <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                                </button>
                            </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                            <div class="row">
                                <div class="col-md-2" style="text-align: -webkit-center;">
                                    <div class="form-group margem">
                                        <div class="wrapper-image">
                                            <div class="image-container">
                                                <i class="fas fa-image"></i>
                                            </div>
                                            <label for="file" class="camera-icon">
                                            <i class="fas fa-camera"></i>
                                            </label>
                                            <input type="file" id="file" name="file" accept="image/*" hidden>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group margem">
                                      <small class="not-required">Nome do Website</small>
                                        <input type="text" class="form-control" id="titulo" name="titulo" placeholder="Título do site" title="Título do site">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="not-required">Endereço</small>
                                        <input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço do site" title="Endereço do site">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="not-required">E-mail</small>
                                        <input type="text" class="form-control" id="email" name="email" placeholder="E-mail do site" title="E-mail do site">
                                        <small>Mensagem de erro</small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group margem">
                                      <small class="not-required">Rodapé</small>
                                        <input type="text" class="form-control" id="rodape" name="rodape" placeholder="Rodapé do site" title="Rodapé do site">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="not-required">Número de Telefone</small>
                                        <input type="text" class="form-control" id="telefone" name="telefone" placeholder="Telefone do site" title="Telefone do site">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="not-required">NIF (Número de Identificação Fiscal)</small>
                                        <input type="text" class="form-control" id="nif" name="nif" placeholder="Número de identificação fiscal" title="Número de identificação fiscal (NIF)">
                                        <small>Mensagem de erro</small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group margem">
                                      <small class="not-required">URL do Website</small>
                                        <input type="text" class="form-control" id="site" name="site" placeholder="Website" title="Website">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group">
                                      <small>Botão</small>
                                        <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary">Guardar definições</button>
                                    </div>
                                </div>
                            </div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer" style="padding-bottom: 0;">
                                <div class="callout callout-info">
                                    <p><i class="icon fas fa-exclamation-triangle"></i>
                                    Nota: Crie as configurações do sistema.</p>
                                </div>
                            </div>
                        </div>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
            </form>
        </section>
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="../../plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="../../plugins/moment/moment.min.js"></script>
<script src="../../plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="../../plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="../../plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="../../plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="../../plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="../../plugins/dropzone/min/dropzone.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<script src="../../image.js"></script>
<script src="../../dist/js/sweetalert.min.js"></script>
<script src="../validation/formulario/curso.js"></script>
<!-- Page specific script -->
<script>
    let img_antiga;
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
  });

  $(document).ready(function(){
  $.ajax({
    url: "../../php/select/periodo.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione periodo</option>";
      for(var key in data){
        select += "<option value="+data[key]['idPeriodo']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#periodo").html(select);
    }
  });
});

$(document).ready(function(){
  $.ajax({
    url: "../../php/select/duracao.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione Duração</option>";
      for(var key in data){
        select += "<option value="+data[key]['idDuracao']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#duracao").html(select);
    }
  });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/read/queryConfiguracao.php",
        type: "post",
        dataType: "json",
        success: function(data){
          console.log(data);
          img = document.querySelector(".image-container");
          titulo = document.getElementById("titulo");
          rodape = document.getElementById("rodape");
          endereco = document.getElementById("endereco");
          telefone = document.getElementById("telefone");
          email = document.getElementById("email");
          nif = document.getElementById("nif");
          site = document.getElementById("site");

          console.log("Está aqui a imagem: ", img);
          img.style.backgroundImage = "url('../../images/logo/" + data[0]['valor'] + "')";
          img.querySelector("i").style.display = "none";

          img_antiga = data[0]['valor'];
          titulo.value = data[1]["valor"];
          rodape.value = data[2]["valor"];
          endereco.value = data[3]["valor"];
          telefone.value = data[4]["valor"];
          email.value = data[5]["valor"];
          nif.value = data[6]["valor"];
          site.value = data[7]["valor"];
        }
      });
});

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  let form_data = new FormData();
  let img = $("#file")[0].files;
  let titulo = document.getElementById("titulo");
  let rodape = document.getElementById("rodape");
  let endereco = document.getElementById("endereco");
  let telefone = document.getElementById("telefone");
  let email = document.getElementById("email");
  let nif = document.getElementById("nif");
  let site = document.getElementById("site");

  form_data.append('file', img[0]);
  form_data.append('img_antiga', img_antiga);
  form_data.append('titulo', titulo.value);
  form_data.append('rodape', rodape.value);
  form_data.append('endereco', endereco.value);
  form_data.append('telefone', telefone.value);
  form_data.append('email', email.value);
  form_data.append('nif', nif.value);
  form_data.append('site', site.value);

  $.ajax({
      url: "../../php/create/configuracao.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data){
        console.log(data);
        swal({
          title: "Alterações gravadas com sucesso!",
          text: "Configurações gravadas!",
          icon: "success",
        });
      },
      error: function(data){
        swal({
          title: "Erro ao alterar configurações!",
          text: "Erro ao configurações configurações: "+ titulo.value +" !",
          icon: "error",
      });
      }
    });
});
</script>
</body>
</html>
