<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Listagem aluno</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../../plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
            <div class="row">
                <div class="col-12">

                <div class="card">
                    <div class="card-header">
                    <div class="col-sm-6">
                      <div class="form-group margem">
                        <p class="card-title breadcrumb-item active" style="padding: .375rem;">Listagem - Aluno</p>
                      </div>
                    </div>
                    <div class="float-sm-right col-md-2">
                      <div class="form-group margem">
                        <a href="../formulario/aluno.php" class="btn btn-block btn-outline-success">Adicionar aluno</a>
                      </div>
                    </div>
                    <div class="float-sm-right col-md-2">
                      <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" name="turma" id="turma" title="Turma">
                        <option value="">Selecione turma</option>
                        </select>
                      </div>
                    </div>
                    <div class="float-sm-right col-md-2">
                      <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" name="curso" id="curso" title="Curso">
                        <option value="0">Selecione curso</option>
                        </select>
                      </div>
                    </div>
                    <div class="float-sm-right col-md-2">
                      <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" name="periodo" id="periodo" title="Período">
                        </select>
                      </div>
                    </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                    <table id="tabelaAluno" class="table table-bordered table-striped" style="line-height: 0.8;">
                    <thead>
                        <tr>
                          <th title="Identificador do aluno">Id aluno</th>
                          <th title="Código do aluno">Código</th>
                          <th title="Nome completo do aluno">Nome completo</th>
                          <th title="Bilhete de identidade do aluno">B.I</th>
                          <th title="Nº de telefone do aluno">Telefone</th>
                          <th title="Endereço do aluno">Endereço</th>
                          <th title="Nome de usuário do aluno">Nome usuário</th>
                          <th title="Tipo de usuário do aluno">Tipo usuário</th>
                          <th title="Estado de actividade (Activo, Inactivo)">Estado</th>
                        </tr>
                    </thead>
                    <tbody id="corpoTabela">
                        
                    </tbody>
                    </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
            </div>
        </section>
        <div class="modal fade" id="modal-updateAluno">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header" style="padding: 0.5rem;">
                <h3 class="card-title p-3"><p class="card-title breadcrumb-item active">Aluno - <span id="nomeModal"></span></p></h3>
                <ul class="nav nav-pills ml-auto p-2">
                  <li class="nav-item" style="margin-right: 0.4rem;"><a class="nav-link active" href="#tab_info" data-toggle="tab" id="info">Informações</a></li>
                  <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#">
                      Acções <span class="caret"></span>
                    </a>
                    <div class="dropdown-menu">
                      <a class="dropdown-item" tabindex="-1" href="#tab_editar" data-toggle="tab" id="btn-update">Editar</a>
                      <div class="dropdown-divider"></div>
                      <a class="dropdown-item" tabindex="-1" href="#btn-delete" id="btn-delete">Eliminar</a>
                      <div class="dropdown-divider"></div>
                      <a class="dropdown-item" tabindex="-1" href="#tab_carregar" data-toggle="tab" id="carregar">Carregar ficheiros</a>
                    </div>
                  </li>
                </ul>
            </div>
            <div class="modal-body" style="padding-bottom: 0px;">
            <div class="tab-content">
              <div class="tab-pane active" id="tab_info">
                <div class="row">
                  <div class="col-md-12">
                    <form name="tabelaFactura">
                      <table name="tabelaFactura" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                        <tr name="linhaItem">
                          <td style="width: 400px;">
                            <div class="form-group margem wrapper-info">
                              <div class="caixa image-info" id="imagemInfo">
                              <i class="fas fa-image"></i>
                              </div>
                            </div>
                          </td>
                          <td style="padding: 20px 0px 0px 10px;">
                            <p>Id do aluno: <span id="idInfo"></span>, &nbsp; Código: <span id="codigoInfo"></span></p>
                            <p>Nome do aluno: <span id="nomeInfo"></span>, &nbsp; Nome usuário: <span id="nomeUsuarioInfo"></span></p>
                            <p>Período: <span id="periodoInfo"></span>, &nbsp; Curso: <span id="cursoInfo"></span></p>
                            <p>Turma: <span id="turmaInfo"></span>, &nbsp; Género: <span id="generoInfo"></span></p>
                            <p>Bilhete de identidade: <span id="biInfo"></span>, &nbsp; E-mail: <span id="emailInfo"></span></p>
                            <p>Endereço: <span id="enderecoInfo"></span>, &nbsp; Telefone: <span id="telefoneInfo"></span></p>
                            <p>Data de nascimento: <span id="dataNascInfo"></span>, &nbsp; Data de admissão: <span id="dataAdmissaoInfo"></span></p>
                          </td>
                        </tr>
                      </table>
                    </form>
                  </div>
                </div>
              </div>
              <!-- /.tab-pane -->
              <div class="tab-pane" id="tab_editar">
              <div class="row">
                <div class="col-md-2" style="text-align: -webkit-center;">
                    <div class="form-group margem">
                        <div class="wrapper-image">
                            <div class="image-container">
                                <i class="fa fa-user"></i>
                            </div>
                            <label for="file" class="camera-icon">
                            <i class="fas fa-camera"></i>
                            </label>
                            <input type="file" id="file" name="file" accept="image/*" hidden>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group margem">
                        <input type="text" class="form-control" id="nome" name="nome" placeholder="*Nome completo" title="Nome completo">
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <input type="email" class="form-control" id="email" name="email" placeholder="E-mail" title="E-mail">
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <input type="text" class="form-control" id="telefone" name="telefone" placeholder="Telefone" title="Número de telefone">
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <input type="text" class="form-control" id="bi" name="bi" placeholder="Bilhete de identidade" title="Bilhete de identidade">
                        <small>Mensagem de erro</small>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-md-3">
                    <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" id="idPeriodo" name="idPeriodo" title="Selecione um período">
                        <option value='0'>Selecione período</option>
                        </select>
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" id="idCurso" name="idCurso" title="Selecione um curso">
                        <option value='0'>Selecione curso</option>
                        </select>
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <input type="text" class="form-control" id="duracao" name="duracao" placeholder="Duração do curso" title="Duração do curso" disabled>
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço" title="Endereço">
                        <small>Mensagem de erro</small>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-md-3">
                    <div class="form-group margem">
                        <input type="date" class="form-control" id="dataNasc" name="dataNasc" placeholder="Data de nascimento" title="Data de nascimento">
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" id="genero" name="genero" title="Género (Masculino, Feminino)">
                        <option value='0'>Selecione gênero</option>
                        <option value="Masculino">Masculino</option>
                        <option value="Feminino">Feminino</option>
                        </select>
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" id="tipoUsuario" name="tipoUsuario" title="Selecione um tipo de usuário" disabled>
                          <option value='2'>Aluno</option>
                        </select>
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group">
                        <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary" disabled>Gravar alterações</button>
                    </div>
                </div>
              </div>
              </div>
              <div class="tab-pane" id="tab_carregar">
                <div class="row">
                  <div class="col-md-12">
                  <table id="tabelaFicheiro" name="tabelaFicheiro" class="table table-sm" style="min-width: 100%;
                        max-width: 100%; margin-bottom: 0;">
                    <tbody>
                      <tr name="linhaItem">
                        <td style="border: none;">
                        <div class="form-group margem">
                        <div class="input-group">
                          <div class="custom-file">
                            <input type="file" class="custom-file-input" id="ficheiro">
                            <label class="custom-file-label" for="ficheiro" style="border-top-left-radius: 0.25rem;border-bottom-left-radius: 0.25rem;border-top-right-radius: 0;border-bottom-right-radius: 0;">Escolher ficheiro...</label>
                          </div>
                          <div class="input-group-append">
                            <button class="input-group-text" name="upload">Carregar</button>
                          </div>
                        </div>
                            <small>Mensagem de erro</small>
                        </div>
                        </td>
                        <td style="border: none;">
                          <div class="form-group margem">
                            <input type="text" class="form-control" id="documento" name="documento" placeholder="Nome do documento" title="Nome do documento">
                            <small>Mensagem de erro</small>
                        </div>
                        </td>
                        <td style="border: none;">
                          <div class="form-group">
                            <button class='btn btn-block btn-outline-success' id='adicionar' name='adicionar'>Adicionar</button>
                          </div>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                  </div>
                </div>
              </div>
            </div>
            
        </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
    <!-- /.content -->
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="../../plugins/jszip/jszip.min.js"></script>
<script src="../../plugins/pdfmake/pdfmake.min.js"></script>
<script src="../../plugins/pdfmake/vfs_fonts.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<script src="../../plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<script src="../../image.js"></script>
<script src="../../dist/js/sweetalert.min.js"></script>
<script src="../validation/listagem/aluno.js"></script>
<!-- Page specific script -->
<script>

$(function () {
  bsCustomFileInput.init();
});

  $(document).on("click", "#info", function(e){
  e.preventDefault();
  let div = document.getElementsByClassName("modal-footer")[0];
  div.classList.remove("justify-content-between");
  div.innerHTML = `<button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>`;
  console.log(document.getElementsByClassName("modal-footer")[0]);
});
$(document).on("click", "#btn-update", function(e){
  e.preventDefault();
  let div = document.getElementsByClassName("modal-footer")[0];
  div.classList.remove("justify-content-between");
  div.innerHTML = `<button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>`;
  console.log(document.getElementsByClassName("modal-footer")[0]);
});
$(document).on("click", "#btn-delete", function(e){
  e.preventDefault();
  let div = document.getElementsByClassName("modal-footer")[0];
  div.classList.remove("justify-content-between");
  div.innerHTML = `<button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>`;
  console.log(document.getElementsByClassName("modal-footer")[0]);
});
$(document).on("click", "#carregar", function(e){
  e.preventDefault();
  let div = document.getElementsByClassName("modal-footer")[0];
  div.classList.add("justify-content-between");
  div.innerHTML = `<button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
              <button type="button" class="btn btn-primary" id="carregarDoc">Carregar documentos</button>`;
  console.log(document.getElementsByClassName("modal-footer")[0]);
  $(document).on("click", "#carregarDoc", function(e){
    e.preventDefault();
    console.log("Apertei para carregar!");
  });
});

$(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
});

$(document).ready(function(){
  $.ajax({
    url: "../../php/select/periodo.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione periodo</option>";
      for(var key in data){
        select += "<option value="+data[key]['idPeriodo']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#periodo").html(select);
    }
  });
});

$(document).ready(function(){
  var i = 1;
  $(document).on("click", "#adicionar", function(e){
    e.preventDefault();
    i++;
    console.log("Cliquei!");
    let ficheiro = `
      <tr id="row${i}" name="linhaItem">
        <td style="border: none;">
        <div class="form-group margem">
        <div class="input-group">
          <div class="custom-file">
            <input type="file" class="custom-file-input" id="ficheiro">
            <label class="custom-file-label" for="ficheiro" style="border-top-left-radius: 0.25rem;border-bottom-left-radius: 0.25rem;border-top-right-radius: 0;border-bottom-right-radius: 0;">Escolher ficheiro...</label>
          </div>
          <div class="input-group-append">
            <button class="input-group-text" name="upload">Carregar</button>
          </div>
        </div>
            <small>Mensagem de erro</small>
        </div>
        </td>
        <td style="border: none;">
          <div class="form-group margem">
            <input type="text" class="form-control" id="documento" name="documento" placeholder="Nome do documento" title="Nome do documento">
            <small>Mensagem de erro</small>
        </div>
        </td>
        <td style="border: none;">
          <div class="form-group">
            <button class='btn btn-block btn-outline-danger remove_row' type='button' id='${i}' name='remover'>Remover</button>
          </div>
        </td>
      </tr>
    `;
    
    $("#tabelaFicheiro").append(ficheiro);
    $(document).on("click", ".remove_row", function(e){
      var row_id = $(this).attr("id");
      //console.log("Esse é o id: ", row_id);
      $(`#row${row_id}`).remove();
    });
  });
  //upload();
});

$(document).ready(function(){
  upload();
});

$(document).on("change", "#periodo", function(e){
  e.preventDefault();
  var periodo = $(this).val();
  $.ajax({
    url: "../../php/select/queryCurso.php",
    type: "post",
    dataType: "json",
    data: {
      periodo: periodo
    },
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione curso</option>";
      for(var key in data){
        select += "<option value="+data[key]['idCurso']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#curso").html(select);
    }
  });
});


$(document).ready(function(){
  $.ajax({
    url: "../../php/select/periodo.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione periodo</option>";
      for(var key in data){
        select += "<option value="+data[key]['idPeriodo']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#idPeriodo").html(select);
    }
  });
});

$(document).on("change", "#idPeriodo", function(e){
  e.preventDefault();
  var periodo = $(this).val();
  $.ajax({
    url: "../../php/select/queryCurso.php",
    type: "post",
    dataType: "json",
    data: {
      periodo: periodo
    },
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione curso</option>";
      for(var key in data){
        if(data[key]['estado'] == 'Inactivo'){
          select += "<option disabled='disabled' value="+data[key]['idCurso']+">"+data[key]['nome']+"</option>";
        } else {
          select += "<option value="+data[key]['idCurso']+">"+data[key]['nome']+"</option>";
        }
      }
      console.log(select);
      $("#idCurso").html(select);
    }
  });
});

$(document).on("change", "#curso", function(e){
  e.preventDefault();
  var curso = $(this).val();
  $.ajax({
    url: "../../php/select/queryTurma.php",
    type: "post",
    dataType: "json",
    data: {
      curso: curso
    },
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione turma</option>";
      for(var key in data){
        select += "<option value="+data[key]['idTurma']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#turma").html(select);
    }
  });
});

$(document).on("change", "#turma", function(e){
  e.preventDefault();
  var turma = $(this).val();
  $.ajax({
    url: "../../php/select/queryAluno.php",
    type: "post",
    dataType: "json",
    data: {
      turma: turma
    }
    }).done(function(data){
      console.log("Está aqui a lista de alunos filtrada: ", data);
      $("#tabelaAluno").DataTable().clear().draw();
      $("#tabelaAluno").DataTable().rows.add(data);
      $("#tabelaAluno").DataTable().columns.adjust().draw();
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/read/aluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        $("#tabelaAluno").DataTable({
        "aaData": data,
        "columns": [{data: "idUsuario"}, {data: "descricao"}, {data: "nome"}, {data: "bi"}, {data: "telefone"}, {data: "endereco"}, {data: "nomeUsuario"}, {data: "nomeTipoUsuario"}, {data: "estado"}],
        "responsive": true, "lengthChange": false, "autoWidth": false, "language": idiomaPortugues, 
        lengthMenu: [[7, 25, 50, -1], [10, 25, 50, 'All']], 
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tabelaAluno_wrapper .col-md-6:eq(0)');
    });
});

var idiomaPortugues = {
  buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
  },
  "sProcessing": "A processar...",
  "sLengthMenu": "Mostrar _MENU_ dos registros",
  "sZeroRecords": "Sem resultados!",
  "sEmptyTable": "Tabela sem dados disponíveis",
  "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
  "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
  "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Pesquisar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "A carregar...",
  "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
  },
  "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
  }
}

function upload(){
  $(document).on("click", "[name='upload']", function(e){
    e.preventDefault();
    let ficheiro;
    let nome;
    let doc;
    for(let i = 0; i < $(this).length; i++){
      ficheiro = $(this).parents('tr')[i].getElementsByTagName('input')[0];
      nome = $(this).parents('tr')[i].getElementsByTagName('input')[1];
      
    }

    doc = ficheiro.files
    console.log(nomeEdit.innerText);

    let form_data = new FormData();
      form_data.append('id', idAluno);
      form_data.append('nomeUsuario', nomeEdit.innerText);
      form_data.append('nome', nome.value);
      form_data.append('documento', doc[0]);

      $.ajax({
      url: "../../php/create/documento.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data){
        console.log("Documento carregado com sucesso!: ", data);
      }
    });
      
    });
  }

$(document).on("click", "#btn-delete", function(e){
  e.preventDefault();
  console.log(idAluno);
  swal({
    title: "Tem a certeza que pretende eliminar aluno?",
    text: "Aluno: "+ nome.value,
    icon: "warning",
    buttons: true,
    dangerMode: true,
  })
  .then((willDelete) => {
    if (willDelete) {
      $.ajax({
        url: "../../php/delete/usuario.php",
        type: "post",
        dataType: "json",
        data: {
          idAluno: idAluno
      },
      success:function(data){
        console.log(data);
        updateTable();
        swal("Aluno "+ nome.value +" eliminado com sucesso!", {
        icon: "success",
      });
      },
      error: function(data){
        swal({
          title: "Erro ao eliminar aluno!",
          text: "Erro ao apagar aluno: "+ nome.value +" !",
          icon: "error",
      });
      }
      });
    }
  });
});

$('#tabelaAluno tbody').on('click', 'td', function () {
    let tabela = document.getElementById("tabelaAluno");
    
    for(i = 1; i < tabela.rows.length; i++){
      tabela.rows[i].ondblclick = function(){
          idAluno = this.cells[0].innerHTML;
          nomeEdit = this.cells[2];
          biEdit = this.cells[3];
          telefoneEdit = this.cells[4];
          enderecoEdit = this.cells[5];

          console.log("Linha: ", this.rowIndex);
          //tabela.deleteRow(this.rowIndex);
          console.log(idAluno);
          ajax();
          //$('#modal-lg').modal('show');
          //this.classList.remove("selected");
      }
    }

    function ajax(){
      $.ajax({
        url: "../../php/read/queryAluno.php",
        type: "post",
        dataType: "json",
        data: {
          idAluno: idAluno
        },
        success: function(data){
          imagemInfo = document.getElementById("imagemInfo");
          img = document.querySelector(".image-info");
          idInfo = document.getElementById("idInfo");
          codigoInfo = document.getElementById("codigoInfo");
          nomeInfo = document.getElementById("nomeInfo");
          classeInfo = document.getElementById("classeInfo");
          turnoInfo = document.getElementById("turnoInfo");
          generoInfo = document.getElementById("generoInfo");
          emailInfo = document.getElementById("emailInfo");
          telefoneInfo = document.getElementById("telefoneInfo");
          enderecoInfo = document.getElementById("enderecoInfo");
          nomeUsuarioInfo = document.getElementById("nomeUsuarioInfo");
          dataNascInfo = document.getElementById("dataNascInfo");
          dataAdmissaoInfo = document.getElementById("dataAdmissaoInfo");
          biInfo = document.getElementById("biInfo");
          nomeModal = document.getElementById("nomeModal");

          nomeUpdate = document.getElementById("nome");
          emailUpdate = document.getElementById("email");
          dataNascUpdate = document.getElementById("dataNasc");
          telefoneUpdate = document.getElementById("telefone");
          enderecoUpdate = document.getElementById("endereco");
          biUpdate = document.getElementById("bi");
          generoUpdate = document.getElementById("genero");
          imgUpdate = document.querySelector(".image-container");
          
            for(var key in data){
              if(data[key]['imagem'] != null){
                img.querySelector("i").style.display = "none";
                imagemInfo.style.backgroundImage = "url('../../images/fotoPerfil/" + data[key]['imagem'] + "')";
                console.log("Tem imagem!");
              } else {
                console.log("Não tem imagem!");
                img.querySelector("i").style.display = "block";
                imagemInfo.style.backgroundImage = "url('../../images/fotoPerfil/" + data[key]['imagem'] + "')";
            }
            
            nomeModal.innerText = data[key]['nome'];
            idInfo.innerText = data[key]['idUsuario'];
            codigoInfo.innerText = data[key]['codigo'];
            nomeInfo.innerText = data[key]['nome'];
            periodoInfo.innerText = data[key]['periodo'];
            cursoInfo.innerText = data[key]['curso'];
            turmaInfo.innerText = data[key]['turma'];
            generoInfo.innerText = data[key]['genero'];
            emailInfo.innerText = data[key]['email'];
            telefoneInfo.innerText = data[key]['telefone'];
            enderecoInfo.innerText = data[key]['endereco'];
            nomeUsuarioInfo.innerText = data[key]['nomeUsuario'];
            dataNascInfo.innerText = data[key]['dataNasc'];
            dataAdmissaoInfo.innerText = data[key]['dataAdesao'];
            biInfo.innerText = data[key]['bi'];

            imgUpdate.style.backgroundImage = "url('../../images/fotoPerfil/" + data[key]['imagem'] + "')";
            imgUpdate.querySelector("i").style.display = "none";

            $('#genero').val(data[key]['genero']);
            $('#genero').select2().trigger('change');

            $('#idPeriodo').val(data[key]['idPeriodo']);
            $('#idPeriodo').select2().trigger('change');

            $('#idCurso').val(data[key]['idCurso']);
            $('#idCurso').select2().trigger('change');

            nomeUpdate.value = data[key]['nome'];
            emailUpdate.value = data[key]['email'];
            dataNascUpdate.value = data[key]['dataNasc'];
            telefoneUpdate.value = data[key]['telefone'];
            enderecoUpdate.value = data[key]['endereco'];
            biUpdate.value = data[key]['bi'];
          }
        }
      }).done(function(data){
        $('#modal-updateAluno').modal('show');
      });
    }
});

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  if(idPeriodo.value != 0 && idCurso.value != 0 && genero.value != 0 && dataNasc.value != ''){
    if(telefone.value == ''){
      telefone.value = 0;
    }
    let img = $("#file")[0].files;
    aluno(img);
  }
});

function foto(identificador, img){
  let form_data = new FormData();
    form_data.append('id', identificador);
    form_data.append('imagem', img[0]);

  $.ajax({
      url: "../../php/create/foto.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data){
        console.log("Foto cadastrada com sucesso!");
      }
    });
}

function aluno(img){
  swal({
    title: "Tem a certeza que pretende editar dados?",
    text: "Aluno: "+ nome.value,
    icon: "warning",
    buttons: true,
  })
  .then((willUpdate) => {
  if (willUpdate) {
  $.ajax({
      url: "../../php/update/aluno.php",
      type: "post",
      data: {
        idAluno: idAluno,
        nome: nome.value,
        email: email.value,
        dataNasc: dataNasc.value,
        telefone: telefone.value,
        endereco: endereco.value,
        bi: bi.value,
        genero: genero.value,
        tipoUsuario: tipoUsuario.value,
        periodo: idPeriodo.value,
        curso: idCurso.value
      },
      success: function(data){
        console.log(data);
        nomeEdit.innerText = nome.value;
        biEdit.innerText = bi.value;
        telefoneEdit.innerText = telefone.value;
        enderecoEdit.innerText = endereco.value;
        swal({
          title: "Edição efectuada com sucesso!",
          text: "Aluno "+ nome.value +" actualizado!",
          icon: "success",
        }).then(() => {
          if(img[0] != null){
            console.log("Este é o id do aluno: ", idAluno);
            foto(idAluno, img);
          }
        });
      },
      error: function(data){
        swal({
          title: "Erro ao editar aluno!",
          text: "Erro ao editar aluno: "+ nome.value +" !",
          icon: "error",
      });
      }
    });
  }
});
}

function updateTable(){
  $.ajax({
        url: "../../php/read/aluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
      console.log("Está aqui a lista de alunos filtrada: ", data);
      $("#tabelaAluno").DataTable().clear().draw();
      $("#tabelaAluno").DataTable().rows.add(data);
      $("#tabelaAluno").DataTable().columns.adjust().draw();
    });
}
</script>
</body>
</html>
